 ; Ŀ
 ;   Tk - text/mtext/attribute editor with source entity kill.             
 ;   Copyright 1994, 1999, 2009 by Rocket Software Ltd.                    
 ;   Software that works, for people who'd rather not...                   
 ; 

 ; Ŀ
 ;   Atc - count the attributes in a block.                                
 ;   Takes one argument, a block ename.                                    
 ;   Returns a number or nil.                                              
 ;   Note that the number of attributes in a block is not necessarily      
 ;   the same as the number in the matching block definition.              
 ; 
 (DEFUN ATC (enam / entt num)
  (if (and (setq entt (entget enam))
           (= (cdr (assoc 0 entt)) "INSERT")
           (assoc 66 entt))
      (progn
           (setq num 0)
           (while (/= "SEQEND" (cdr (assoc 0
                                    (entget (setq enam (entnext enam))))))
                  (setq num (1+ num)))))
 num)
 ; Ŀ
 ;   Atc end.                                                              
 ; 

 ; Ŀ
 ;   Tk.                                                                   
 ; 
 (DEFUN C:TK (/ snapp *error* enam nent typ entt renam outer nn sentt source
                                                    subtyp cc atts sout styp)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if shk (write-line shk))
   (setvar "snapmode" snapp)
   (if renam (redraw renam 4))
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get a text string destination entity.                                 
 ; 
  (setq enam (car (setq nent (nentsel "Select something textlike: "))))
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (if (or (= "TEXT" typ) (= "MTEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
      (progn
           (princ (cdr (assoc 1 entt)))
           (redraw (setq renam (cdr (assoc -1 entt))) 3)
           (setq outer (car (reverse (car (reverse nent)))))
 ; Ŀ
 ;   Get a string source entity.                                           
 ; 
           (setq nn (nentsel "\nSelect source text:\n"))
           (setq sentt (entget (setq source (car nn))))
           (setq subtyp (cdr (assoc 0 sentt)))
           (if nn (setq cc (assoc 1 sentt)))
           (if cc (setq cc (cdr cc)))
 ; Ŀ
 ;   If we have a good replacement string, insert it and update the entt.  
 ; 
           (if (and cc (/= cc ""))
               (progn
                    (redraw renam 4)
                    (entmod (subst (cons 1 cc) (assoc 1 entt) entt))
                    (entupd enam)
                    (if (= (type outer) 'ENAME) (entupd outer))
 ; Ŀ
 ;   Decide whether to erase the source entity.                            
 ;   If the source entity was part of a block, count the attributes.       
 ; 
                    (if (= subtyp "ATTRIB")
                        (progn
                             (setq enam (cdr (assoc 330 sentt)))
                             (setq atts (atc enam))))
 ; Ŀ
 ;   If the entity wasn't an attribute and was part of something else,     
 ;   get its entity type.                                                  
 ; 
                    (setq sout (car (reverse (car (reverse nn)))))
                    (if (= (type sout) 'ENAME)
                        (setq styp (cdr (assoc 0 (entget sout)))))
 ; Ŀ
 ;   Delete the source entity if it wasn't part of a block or was but      
 ;   was the only attribute therein.                                       
 ; 
                    (cond ((and (= subtyp "ATTRIB")
                                (= atts 1))
                           (entdel (cdr (assoc 330 sentt))))
                          ((null styp)
                           (entdel source))))
               (redraw renam 4))))
  (*error* ())
 (princ))